// priority : 180
onEvent('tags.items', (event) => {
    //Heart fragments
    event.add('kubejsadditions:heart_fragment', 'kubejsadditions:yellow_heart_fragment');
    event.add('kubejsadditions:heart_fragment', 'kubejsadditions:blue_heart_fragment');
    event.add('kubejsadditions:heart_fragment', 'kubejsadditions:red_heart_fragment');
    event.add('kubejsadditions:heart_fragment', 'kubejsadditions:green_heart_fragment');

    //Ice
    event.add('forge:ice', 'minecraft:ice');
    event.add('forge:ice', 'minecraft:packed_ice');
    event.add('forge:ice', 'minecraft:blue_ice');
    event.add('forge:ice', 'soul_ice:soul_ice');

    //compressed blocks
    event.add('kubejadditions:compressed_soils', 'compressium:dirt_5');
    event.add('kubejadditions:compressed_soils', 'compressium:sand_5');
    event.add('kubejadditions:compressed_soils', 'compressium:soulsand_5');
    event.add('kubejadditions:compressed_soils', 'compressium:redsand_5');
    event.add('kubejadditions:compressed_soils', 'compressium:gravel_5');

    event.add('kubejsadditions:compressed_ores', 'compressium:diamond_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:emerald_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:gold_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:lapis_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:netherite_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:copper_5');
    event.add('kubejsadditions:compressed_ores', 'compressium:iron_5');

    //Building gadget blacklist
    event.add("buildinggagdets:blacklist/generic", [
        '#ae2:smart_cable',
        '#ae2:covered_cable',
        '#ae2:glass_cable',
        '#ae2:covered_dense_cable',
        '#ae2:smart_dense_cable',
        'ae2:cable_anchor',
        'ae2:import_bus',
        'ae2:export_bus',
        'ae2:quartz_fiber'
    ]);

    //Limestone from Quark for the purposes of crafting the limestone seed
    event.add('mysticalagriculture:material/limestone', 'quark:limestone');

    //To unify Niter and Salpeter from IE
    event.add('forge:dusts/saltpeter', 'thermal:niter_dust');

    //Remove all IE Lead traces, but we keep the ore in worldgen and adjust the processing with it in unify.js
    event.removeAllTagsFrom('immersiveengineering:nugget_lead')
    event.removeAllTagsFrom('immersiveengineering:ingot_lead')
    event.removeAllTagsFrom('immersiveengineering:raw_lead')
    event.removeAllTagsFrom('mekanism:lead_ore')
    event.removeAllTagsFrom('mekanism:deepslate_lead_ore')
    event.removeAllTagsFrom('immersiveengineering:dust_lead')
    event.removeAllTagsFrom('immersiveengineering:ore_lead')
    event.removeAllTagsFrom('immersiveengineering:deepslate_ore_lead')
    event.removeAllTagsFrom('mekanism:raw_lead')
    event.removeAllTagsFrom('mekanism:nugget_lead')
    event.removeAllTagsFrom('mekanism:ingot_lead')
    event.removeAllTagsFrom('mekanism:dust_lead')

    event.removeAllTagsFrom('immersiveengineering:nugget_uranium')
    event.removeAllTagsFrom('immersiveengineering:ingot_uranium')
    event.removeAllTagsFrom('immersiveengineering:raw_uranium')
    event.removeAllTagsFrom('immersiveengineering:ore_uranium')
    event.removeAllTagsFrom('immersiveengineering:deepslate_ore_uranium')
    event.removeAllTagsFrom('immersiveengineering:dust_uranium')

    event.removeAllTagsFrom('immersiveengineering:ingot_steel')
    event.removeAllTagsFrom('immersiveengineering:nugget_steel')
    event.removeAllTagsFrom('immersiveengineering:dust_steel')

    event.removeAllTagsFrom('immersiveengineering:dust_sulfur')
    event.removeAllTagsFrom('mekanism:dust_sulfur')

    event.removeAllTagsFrom('immersiveengineering:nugget_nickel')
    event.removeAllTagsFrom('immersiveengineering:ingot_nickel')
    event.removeAllTagsFrom('immersiveengineering:raw_nickel')
    event.removeAllTagsFrom('immersiveengineering:ore_nickel')
    event.removeAllTagsFrom('immersiveengineering:deepslate_ore_nickel')
    event.removeAllTagsFrom('immersiveengineering:dust_nickel')

    event.removeAllTagsFrom('mekanism:nugget_tin')
    event.removeAllTagsFrom('mekanism:ingot_tin')
    event.removeAllTagsFrom('mekanism:raw_tin')
    event.removeAllTagsFrom('mekanism:tin_ore')
    event.removeAllTagsFrom('mekanism:deepslate_tin_ore')
    event.removeAllTagsFrom('mekanism:dust_tin')

    event.removeAllTagsFrom('immersiveengineering:nugget_silver')
    event.removeAllTagsFrom('immersiveengineering:ingot_silver')
    event.removeAllTagsFrom('immersiveengineering:raw_silver')
    event.removeAllTagsFrom('immersiveengineering:ore_silver')
    event.removeAllTagsFrom('immersiveengineering:deepslate_ore_silver')
    event.removeAllTagsFrom('immersiveengineering:dust_silver')

    event.removeAllTagsFrom('occultism:raw_silver')
    event.removeAllTagsFrom('occultism:silver_ingot')
    event.removeAllTagsFrom('occultism:silver_nugget')
    event.removeAllTagsFrom('occultism:silver_dust')
    event.removeAllTagsFrom('occultism:silver_ore')
    event.removeAllTagsFrom('occultism:silver_ore_deepslate')
    //Remove the debug miner, it's for debugging
    event.removeAllTagsFrom('occultism:miner_debug_unspecialized')

    event.removeAllTagsFrom('immersiveengineering:dust_saltpeter')
    event.removeAllTagsFrom('jaopca:storage_blocks.saltpeter')

    event.removeAllTagsFrom('immersiveengineering:dust_copper')
    event.removeAllTagsFrom('mekanism:dust_copper')

    event.removeAllTagsFrom('immersiveengineering:dust_gold')
    event.removeAllTagsFrom('mekanism:dust_gold')

    event.removeAllTagsFrom('immersiveengineering:dust_iron')
    event.removeAllTagsFrom('mekanism:dust_iron')

    event.removeAllTagsFrom('mekanism:dust_bronze')
    event.removeAllTagsFrom('mekanism:ingot_bronze')
    event.removeAllTagsFrom('mekanism:nugget_bronze')

    event.removeAllTagsFrom('mekanism:dust_netherite')

    event.removeAllTagsFrom('immersiveengineering:nugget_constantan')
    event.removeAllTagsFrom('immersiveengineering:dust_constantan')
    event.removeAllTagsFrom('immersiveengineering:ingot_constantan')

    event.removeAllTagsFrom('immersiveengineering:nugget_copper')
    event.removeAllTagsFrom('tconstruct:copper_nugget')
    event.removeAllTagsFrom('malum:copper_nugget')
    event.removeAllTagsFrom('create:copper_nugget')

    event.removeAllTagsFrom('immersiveengineering:nugget_electrum')
    event.removeAllTagsFrom('immersiveengineering:dust_electrum')
    event.removeAllTagsFrom('immersiveengineering:ingot_electrum')

    event.removeAllTagsFrom('immersiveengineering:coal_coke')

    event.removeAllTagsFrom('mekanism:dust_emerald')

    event.removeAllTagsFrom('mekanism:dust_diamond')
    event.removeAllTagsFrom('createaddition:diamond_grit')
    event.removeAllTagsFrom('hearthstones:diamond_dust')

    event.removeAllTagsFrom('ae2:ender_dust')

    event.removeAllTagsFrom('hearthstones:lapis_dust')
    event.removeAllTagsFrom('mekanism:dust_lapis_lazuli')

    event.removeAllTagsFrom('create:powdered_obsidian')

    event.removeAllTagsFrom('immersiveengineering:slag')

    event.removeAllTagsFrom('immersiveengineering:dust_wood')
    event.removeAllTagsFrom('mekanism:sawdust')

    event.removeAllTagsFrom('mekanism:dust_quartz')

    event.removeAllTagsFrom('occultism:obsidian_dust')
    event.removeAllTagsFrom('occultism:iron_dust')
    event.removeAllTagsFrom('occultism:gold_dust')
    event.removeAllTagsFrom('occultism:copper_dust')
    event.removeAllTagsFrom('occultism:silver_dust')

    //Elementary Ores
    const elementaryOres = [
        'elementaryores:ore_coal_nether',
        'elementaryores:ore_copper_nether',
        'elementaryores:ore_iron_nether',
        'elementaryores:ore_emerald_nether',
        'elementaryores:ore_lapis_nether',
        'elementaryores:ore_diamond_nether',
        'elementaryores:ore_ghast_nether',
        'elementaryores:ore_coal_end',
        'elementaryores:ore_copper_end',
        'elementaryores:ore_redstone_end',
        'elementaryores:ore_emerald_end',
        'elementaryores:ore_lapis_end',
        'elementaryores:ore_diamond_end',
        'elementaryores:ore_ender_end',
        'elementaryores:ore_redstone_nether',
        'elementaryores:ore_iron_end'
    ];
    elementaryOres.forEach(ore => {
        event.removeAllTagsFrom(ore);
    });

    //Plexiglass blocks
    global.dyes.forEach((dye) => {
        event.add('kubejsadditions:plexiglass', 'kubejsadditions:' + dye + '_plexiglass');
    });
    event.add('kubejsadditions:plexiglass', 'kubejsadditions:clear_plexiglass');

    //Make lightstone usable in recipes as stone
    event.add('forge:stone', 'soul_ice:lightstone');
    event.add('forge:stone', 'soul_ice:hardened_lightstone');

    //Dim Shards
    event.add('forge:ores/dimensional_shard', 'rftoolsbase:dimensionalshard_overworld');
    event.add('forge:ores/dimensional_shard', 'rftoolsbase:dimensionalshard_end');

    //Blazing Quartz
    event.add('forge:ores/blazing_quartz', 'malum:blazing_quartz_ore')

    //Soulstone
    event.add('forge:ores/soulstone', 'malum:soulstone_ore')
});

onEvent('tags.blocks', (event) => {
    event.add('minecraft:needs_iron_tool', 'kubejsadditions:dimensional_shard_block');
    event.add('minecraft:mineable/pickaxe', 'kubejsadditions:dimensional_shard_block');

    event.add('minecraft:mineable/pickaxe', 'kubejsadditions:tesseract_frame');

    event.add('minecraft:needs_diamond_tool', 'kubejsadditions:tesseracted_plexiglass');
    event.add('minecraft:mineable/pickaxe', 'kubejsadditions:tesseracted_plexiglass');

    //Malum wood
    event.add('ultimine:runewood', 'malum:runewood_log');
    event.add('ultimine:runewood', 'malum:exposed_runewood_log');

    //Azalea leaves
    event.add('ultimine:azalea_leaves', 'minecraft:flowering_azalea_leaves');
    event.add('ultimine:azalea_leaves', 'minecraft:azalea_leaves');

    //Minecraft concrete
    global.dyes.forEach((dye) => {
        event.add('minecraft:concrete', 'minecraft:' + dye + '_concrete');
    });

    //Exclude bedrock ores cause buggy (they get deleted) and cheaty to use Ultimine on anyways
    const bedrockOres = [
        'dadobugbedrockores:bedrock_ie_aluminum_ore',
        'dadobugbedrockores:bedrock_fractured',
        'dadobugbedrockores:bedrock_hollow',
        'dadobugbedrockores:bedrock_milk_ore',
        'dadobugbedrockores:bedrock_cookie_ore',
        'dadobugbedrockores:bedrock_coal_ore',
        'dadobugbedrockores:bedrock_iron_ore',
        'dadobugbedrockores:bedrock_gold_ore',
        'dadobugbedrockores:bedrock_diamond_ore',
        'dadobugbedrockores:bedrock_redstone_ore',
        'dadobugbedrockores:bedrock_copper_ore',
        'dadobugbedrockores:bedrock_lapis_ore',
        'dadobugbedrockores:bedrock_emerald_ore',
        'dadobugbedrockores:bedrock_lava_ore',
        'dadobugbedrockores:bedrock_nether_gold_ore',
        'dadobugbedrockores:bedrock_nether_quartz_ore',
        'dadobugbedrockores:bedrock_ancient_debris_ore',
        'dadobugbedrockores:bedrock_bauxite_ore',
        'dadobugbedrockores:bedrock_ie_lead_ore',
        'dadobugbedrockores:bedrock_ie_silver_ore',
        'dadobugbedrockores:bedrock_ie_nickel_ore',
        'dadobugbedrockores:bedrock_ie_uranium_ore',
        'dadobugbedrockores:bedrock_xp_leak'
    ]
    event.add('ftbultimine:excluded_blocks', bedrockOres);

    //For the RFTools Builder to make sure it doesn't remove them
    event.add('rftoolsbuilder:dontremoveme', bedrockOres);

    //Dirty hack to allow surveying End Stone
    //https://github.com/BluSunrize/ImmersiveEngineering/blob/86211504ad15b866e6df4685eb16c239cd6f16bb/src/main/java/blusunrize/immersiveengineering/common/items/SurveyToolsItem.java#L61
    event.add('forge:stone', 'minecraft:end_stone');

    //Fixes https://github.com/FTBTeam/FTB-Modpack-Issues/issues/1235 and for consistency in quarrying
    event.add('forge:stone', 'soul_ice:lightstone');
    event.add('forge:stone', 'soul_ice:hardened_lightstone');

    //Tesseracted Plexiglass beacon
    event.add('minecraft:beacon_base_blocks', 'kubejsadditions:tesseracted_plexiglass');

    //Dim Shards
    event.add('forge:ores/dimensional_shard', 'rftoolsbase:dimensionalshard_overworld');
    event.add('forge:ores/dimensional_shard', 'rftoolsbase:dimensionalshard_end');

    //Blazing Quartz
    event.add('forge:ores/blazing_quartz', 'malum:blazing_quartz_ore')

    //Soulstone
    event.add('forge:ores/soulstone', 'malum:soulstone_ore')
});

onEvent('tags.fluids', (event) => {
    //Add water tag to Crude Oil and Plexiglass to make them swimmable
    event.add('minecraft:water', 'kubejsadditions:molten_plexiglass');
    event.add('minecraft:water', 'pneumaticcraft:oil');

    //Needed to have the plexiglass custom refinery working
    //https://github.com/BluSunrize/ImmersiveEngineering/blob/fd476303fd98aba3da97e0ef269d712192b16ec0/src/main/java/blusunrize/immersiveengineering/common/crafting/serializers/RefineryRecipeSerializer.java#L40
    event.add('immersiveengineering:phenolic_resin', 'immersiveengineering:phenolic_resin');
    event.add('mekanism:sodium', 'mekanism:sodium');

    //Make TConstruct slime island fluids swimmable
    event.add('minecraft:water', 'tconstruct:earth_slime');
    event.add('minecraft:water', 'tconstruct:sky_slime');
    event.add('minecraft:water', 'tconstruct:ender_slime');
    event.add('minecraft:lava', 'tconstruct:magma');
});
